
Type TSelectiveSweepCollider Extends IBroadPhaseCollider

	Global _comparer:TStubComparer = New TStubComparer

	Field _physicsSimulator:TPhysicsSimulator
	Field _wrappers:TList
	Field _xStubArray:TStub[]
	Field _yStubArray:TStub[]
	
	Function Create:TSelectiveSweepCollider(physicsSim:TPhysicsSimulator) 
		Local ssc:TSelectiveSweepCollider = New TSelectiveSweepCollider
		ssc._physicsSimulator = physicsSim
		ssc._wrappers = CreateList() 
		Return ssc
	End Function
	
	Method Add(item:TGeom) 
		Local wrapper:TWrapper = TWrapper.Create(item) 
		_wrappers.AddLast(wrapper) 
		wrapper.AddStubs(_xStubArray, _yStubArray)
	End Method
	
	Method Clear() 
		_wrappers.Clear()
		_xStubArray = New TStub[1]
		_ystubArray = New TStub[1]		
	End Method
	
'#Region Remove methods/functions
	Function WrapperIsRemoved:Int(wrapper:TWrapper) 
		Return wrapper.geom.isRemoved
	End Function
		
	Function StubIsRemoved:Int(stub:TStub) 
		Return stub.wrapper.geom.isRemoved
	End Function
	
	Method ProcessRemovedGeoms() 
		Local match:Int = False
		For Local wrapper:TWrapper = EachIn _wrappers
			If WrapperIsRemoved(wrapper) Then
				match = True
				_wrappers.Remove(wrapper) 
			End If
		Next
		
		If match Then
		
			'implemented as while loops because for-loops in blitzmax
			' appaer to only have constant counters.
			
			Local i:Int = 0
			While i < _xstubarray.Length
				If StubIsRemoved(_xStubArray[i]) Then
					_RemoveStubAtIndex(_xStubArray, i)
					i:-1
				End If
				i:+1
			Wend
			
			i = 0
			While i < _yStubArray.Length
				If StubIsRemoved(_yStubArray[i]) Then
					_RemoveStubAtIndex(_yStubArray, i)
					i:-1
				End If
				i:+1
			WEnd

		End If
	End Method
	
	Method _RemoveStubAtIndex(array:TStub[] Var, index:Int)
		array = array[..index] + array[index + 1..]
	End Method
'#End Region 
	
	' updates all the nodes to their new values and sorts the lists	
	Method InternalUpdate()
		For Local wrapper:TWrapper = EachIn _wrappers
			wrapper.Update() 
		Next
		_xStubArray.Sort()
		_yStubArray.Sort()		
	End Method
	
	' finds how many collision there are on the x and y and returns
	' if x axis as the least
	Method _ShouldDoX:Int()
		Local xCount:Int = 0
		Local xDepth:Int = 0
		Local yCount:Int = 0
		Local yDepth:Int = 0
		For Local index:Int = 0 To _xStubArray.Length - 1
			Local xStub:TStub = TStub(_xStubArray[index])
			Local yStub:TStub = TStub(_yStubArray[index])
			If xStub.begin Then
				xCount:+xDepth
				xDepth:+1
			Else
				xDepth:-1
			End If
			
			If ystub.begin Then
				yCount:+yDepth
				yDepth:+1
			Else
				yDepth:-1
			End If
		Next
		Return xCount < yCount
	End Method
	
	Method Update() 
		InternalUpdate()
		_DetectInternal(_ShouldDoX())
	End Method
	
	Field _currentBodies:TList = CreateList()
	Method _DetectInternal(doX:Int)
		
		Local stubs:TStub[] = _yStubArray
		If doX Then
			stubs = _xStubArray
		End If
		
		_currentBodies.Clear()
		For Local stub:TStub = EachIn stubs
			
			Local wrapper1:TWrapper = stub.wrapper
			If stub.begin Then
				' set min max values
				If doX Then
					wrapper1.SetY() 
				Else
					wrapper1.SetX() 				
				End If
				Local geom1:TGeom = wrapper1.geom	
				For Local wrapper2:TWrapper = EachIn _currentBodies
					Local geom2:TGeom = wrapper2.geom
					If wrapper1.minf <= wrapper2.maxf And wrapper2.minf <= wrapper1.maxf Then
						 _OnCollision(geom1, geom2) 
					End If
				Next
				If wrapper1.shouldAddNode Then
					_currentBodies.AddLast(wrapper1)
				End If
			Else
				If wrapper1.shouldAddNode Then
					_currentBodies.Remove(wrapper1)
				End If
			End If

		Next
	End Method
	
	Method _OnCollision(geom1:TGeom, geom2:TGeom) 
		If Not(geom1._body._enabled) Or Not(geom2._body._enabled) Then
			Return
		End If
		
		If ((geom1._collisionGroup = geom2._collisionGroup) And geom1._collisionGroup <> 0 And geom2._collisionGroup <> 0) 
			Return
		End If
		
		If Not(geom1._collisionEnabled) Or Not(geom2._collisionEnabled) Then
			Return
		End If
		
		If geom1._body.IsStatic() And geom2._body.IsStatic() Then
			Return ' don't collide static bodies
		End If
		
		' collision categories
		If ((geom1._collisionCategories & geom2._collidesWith) = CollisionCategories.None) & ((geom2._collisionCategories & geom1._collidesWith) = CollisionCategories.None) Then
			Return
		End If
		
		Local arbiter:TArbiter = TArbiter(_physicsSimulator._arbiterPool.Fetch()) 
		arbiter.ConstructArbiter(geom1, geom2, _physicsSimulator) 
		If Not(_physicsSimulator._arbiterList.Contains(arbiter)) Then
			_physicsSimulator._arbiterList.add(arbiter) 
		Else
			_physicsSimulator._arbiterPool.Free(arbiter)  
		End If
	End Method
End Type
